//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Override base controls
GuiButtonProfile.soundButtonOver = "AudioButtonOverMenu";

//-----------------------------------------------------------------------------
// Chat Hud profiles


new GuiControlProfile (ChatHudEditProfile)
{
   opaque = false;
   fillColor = "255 255 255";
   fillColorHL = "128 128 128";
   border = false;
   borderThickness = 0;
   borderColor = "40 231 240";
   fontColor = "40 231 240";
   fontColorHL = "40 231 240";
   fontColorNA = "128 128 128";
   textOffset = "0 2";
   autoSizeWidth = false;
   autoSizeHeight = true;
   tab = true;
   canKeyFocus = true;
};


new GuiControlProfile ("WWScrollProfile")
{
   opaque = false;
   border = false;
   borderColor = "0 255 0";
   bitmap = "common/ui/westwardScroll";
   hasBitmapArray = true;
   fontType = "StageCoach";
   fontSize = 20;
   fontColor = "43 28 12";
   textShadow = false;
	textOffset = "2 0";
   autoSizeWidth = false;
   autoSizeHeight = false;
   tab = true;
   canKeyFocus = true;
};


//-----------------------------------------------------------------------------
// Common Hud profiles

new GuiControlProfile ("HudScrollProfile")
{
   opaque = false;
   border = true;
   borderColor = "0 255 0";
   bitmap = "common/ui/darkScroll";
   hasBitmapArray = true;
};

new GuiControlProfile ("HudTextProfile")
{
   opaque = false;
   fillColor = "128 128 128";
   fontColor = "0 255 0";
   border = true;
   borderColor = "0 255 0";
};

new GuiControlProfile ("ChatHudBorderProfile")
{
   bitmap = "./chatHudBorderArray";
   hasBitmapArray = true;
   opaque = false;
};

new GuiControlProfile ("WestwardBorderProfile")
{
   bitmap = "./westwardBorder";
   hasBitmapArray = true;
   opaque = false;
};

//-----------------------------------------------------------------------------
// Center and bottom print

new GuiControlProfile ("CenterPrintProfile")
{
   border = false;
   opaque = false;
   fillColor = "0 0 0 200";
};

new GuiControlProfile ("CenterPrintTextProfile")
{
   border = false;
   opaque = false;
   fontType = "Arial";
   fontSize = 22;
};

new GuiControlProfile ("InfoBoxProfile")
{
   fontColorLink = "255 96 96";
   fontColorLinkHL = "0 0 255";
};

new GuiControlProfile ("InfoBoxBackdropProfile")
{
   fontColorLink = "255 96 96";
   fontColorLinkHL = "0 0 255";
   opaque = true;
   fillColor = "0 0 0 200";
};

new GuiControlProfile (AFXButtonProfile)
{
   fillColor = "0 0 0 100";
   fillColorHL = "254 14 25 32";
   fillColorNA = "20 20 20";

   borderColor = "120 120 120";
   borderColorHL = "157 157 157";
   borderColorNA = "64 64 64";

   opaque = true;
   border = 1;
   fontColor = "60 119 108";
   fontColorHL = "254 14 25";
   fixedExtent = true;
   justify = "center";
	 canKeyFocus = false;
   fontSize = 18;
};

new GuiControlProfile (AFXTextProfile)
{
   fontSize = 18;
   fontColor = "60 119 108";
   fontColorLink = "255 96 96";
   fontColorLinkHL = "0 0 255";
   autoSizeWidth = true;
   autoSizeHeight = true;
};

new GuiControlProfile (AFXCheckBoxProfile)
{
   opaque = false;
   fillColor = "232 232 232";
   border = false;
   borderColor = "0 0 0";
   fontSize = 18;
   fontColor = "60 119 108";
   fontColorHL = "255 18 0";
   fixedExtent = true;
   justify = "left";
   bitmap = "./demoCheck";
   hasBitmapArray = true;
};


new GuiControlProfile (AFXButtonStackProfile)
{
   tab = false;
   canKeyFocus = false;
   hasBitmapArray = false;
   mouseOverSelected = false;

   // fill color
   opaque = false;
   fillColor = "255 0 0 100";
   fillColorHL = "221 202 173";
   fillColorNA = "221 202 173";

   // border color
   border = false;
   borderColor   = "0 0 0"; 
   borderColorHL = "179 134 94";
   borderColorNA = "126 79 37";

   // font
   fontType = "Arial";
   fontSize = 14;

   fontColor = "0 0 0";
   fontColorHL = "32 100 100";
   fontColorNA = "0 0 0";
   fontColorSEL= "200 200 200";

   // bitmap information
   //bitmap = "./demoWindow";
   bitmapBase = "";
   textOffset = "0 0";

   // used by guiTextControl
   modal = true;
   justify = "left";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = false;
   numbersOnly = false;
   cursorColor = "0 0 0 255";

   // sounds
   soundButtonDown = "";
   soundButtonOver = "";
};

// WESTWARD 2 FONT PROFILES 

// XP page tab button fonts
new GuiControlProfile (XPtabButtonProfile)
{
   // font
   fontType = "URWWoodTypD";
   fontSize = 44;

   fontColor = "41 15 2";
   fontColorHL = "76 27 3";
   fontColorNA = "1 1 1";
   fontColorSEL= "76 27 3";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "230 195 117 250";
   textOffset = "0 0";

   // used by guiTextControl
   modal = true;
   justify = "center";
   autoSizeWidth = true;
   autoSizeHeight = true;
   returnTab = false;
   numbersOnly = false;
   cursorColor = "0 0 0 255";
   
   //Sound   
   soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonDownGame";

};

// Large Center
new GuiControlProfile (WWLargeCenterProfile)
{
   // font
   fontType = "URWWoodTypD";
   fontSize = 38;

   fontColor = "41 15 2";
   fontColorHL = "76 27 3";
   fontColorNA = "76 27 3";
   fontColorSEL= "76 27 3";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "230 195 117 250";
   textOffset = "0 0";

   // used by guiTextControl
   modal = true;
   justify = "center";
   autoSizeWidth = true;
   autoSizeHeight = true;
   returnTab = false;
   numbersOnly = false;
   cursorColor = "0 0 0 255";
   
   //Sound   
   soundButtonOver = "AudioButtonOverMenu";
   soundButtonDown = "AudioButtonDownMenu";

};

// Westward dialog font
new GuiControlProfile (WestwardDialogProfile)
{
   // font
   fontType = "StageCoach";
   fontSize = 20;

   fontColor = "43 28 12";
   fontColorHL = "43 28 12";
   fontColorNA = "68 63 56";
   fontColorSEL= "43 28 12";
   textShadow = false;
   textOffset = "0 0";
   textWrap = true;

   // used by guiTextControl
   modal = true;
   justify = "left";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = true;
   numbersOnly = false;
   textResize = false;
};

// Westward dialog font
new GuiControlProfile (WestwardcenterProfile)
{
   // font
   fontType = "StageCoach";
   fontSize = 24;

   fontColor = "43 28 12";
   fontColorHL = "43 28 12";
   fontColorNA = "68 63 56";
   fontColorSEL= "43 28 12";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "200 152 82 250";
   textOffset = "0 0";
   textWrap = true;

   // used by guiTextControl
   modal = true;
   justify = "center";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = true;
   numbersOnly = false;
   textResize = false;
   
   // Sound   
   soundButtonOver = "";
   soundButtonDown = "AudioButtonDownGame";
};

// Westward dialog font
new GuiControlProfile (WestwardcentersmProfile)
{
   // font
   fontType = "StageCoach";
   fontSize = 21;

   fontColor = "43 28 12";
   fontColorHL = "43 28 12";
   fontColorNA = "68 63 56";
   fontColorSEL= "43 28 12";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "200 152 82 250";
   textOffset = "0 0";
   textWrap = true;

   // used by guiTextControl
   modal = true;
   justify = "center";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = true;
   numbersOnly = false;
   textResize = false;
};

// Westward dialog font
new GuiControlProfile (WestwardRightProfile)
{
   // font
   fontType = "StageCoach";
   fontSize = 26;

   fontColor = "43 28 12";
   fontColorHL = "43 28 12";
   fontColorNA = "68 63 56";
   fontColorSEL= "43 28 12";
   textShadow = false;
   textOffset = "0 0";
   textWrap = true;

   // used by guiTextControl
   modal = true;
   justify = "right";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = true;
   numbersOnly = false;
   textResize = false;
};

// Westward dialog font
new GuiControlProfile (WestwardLeftProfile)
{
   // font
   fontType = "StageCoach";
   fontSize = 26;

   fontColor = "43 28 12";
   fontColorHL = "43 28 12";
   fontColorNA = "68 63 56";
   fontColorSEL= "43 28 12";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "0 0 0 255";
   textOffset = "0 0";
   textWrap = true;

   // used by guiTextControl
   modal = true;
   justify = "left";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = true;
   numbersOnly = false;
   textResize = false;
};

new GuiControlProfile (WestwardLargeProfile)
{
   // font
   fontType = "URWWoodTypD";
   fontSize = 26;

   fontColor = "43 28 12";
   fontColorHL = "43 28 12";
   fontColorNA = "68 63 56";
   fontColorSEL= "43 28 12";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "200 152 82 250";
   textOffset = "0 0";

   // used by guiTextControl
   modal = true;
   justify = "right";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = false;
   numbersOnly = false;
   textResize = false;
};
new GuiControlProfile (WestwardDialogsmProfile)
{
   // font
   fontType = "StageCoach";
   fontSize = 20;
   fontColor = "43 28 12";
   fontColorHL = "43 28 12";
   fontColorNA = "68 63 56";
   fontColorSEL= "43 28 12";
   textShadow = false;
   textShadowOffset = "-1 1";
   textShadowColor = "200 152 82 250";
   textOffset = "0 0";
   textWrap = true;

   // used by guiTextControl
   modal = true;
   justify = "left";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = false;
   numbersOnly = false;
   textResize = false;
};
new GuiControlProfile (WestwardHudMessageProfile)
{
   // font
   fontType = "StageCoach";
   fontSize = 20;
   fontColor = "246 223 152";
   fontColorHL = "246 223 152";
   fontColorNA = "246 223 152";
   fontColorSEL= "246 223 152";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "0 0 0 240";
   textOffset = "0 0";
   textWrap = true;

   // used by guiTextControl
   modal = true;
   justify = "center";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = false;
   numbersOnly = false;
   textResize = false;
};
new GuiControlProfile (NashvilleLargeProfile)
{
   // font
   fontType = "Nashville";
   fontSize = 30;

   fontColor = "43 28 12";
   fontColorHL = "107 46 12";
   fontColorNA = "53 46 43";
   fontColorSEL= "43 28 12";
   textShadow = true;
   textShadowOffset = "-1 1";
   textShadowColor = "243 190 103 220";
   textOffset = "0 0";

   // used by guiTextControl
   modal = true;
   justify = "center";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = false;
   numbersOnly = false;
   
   soundButtonOver = "AudioButtonOverMenu";
   soundButtonDown = "AudioButtonDownMenu";

};
//Ranch button sounds
new GuiControlProfile (SelectPigSoundProfile)
{
   //Sound   
   //soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonPig";
};
new GuiControlProfile (SelectChickenSoundProfile)
{
   //Sound   
   //soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonChicken";
};
new GuiControlProfile (SelectCowSoundProfile)
{
   //Sound   
   //soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonCow";
};
new GuiControlProfile (SelectSheepSoundProfile)
{
   //Sound   
   //soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonSheep";
};

new GuiControlProfile (DefaultSoundProfile)
{
   //Sound   
   //soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonDownGame";

};
new GuiControlProfile (QuitjobSoundProfile)
{
   //Sound   
   soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonWhistle";
};

new GuiControlProfile (BuySoundProfile)
{
   //Sound   
   soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonBuyItem";
};
new GuiControlProfile (SellSoundProfile)
{
   //Sound   
   soundButtonOver = "AudioButtonOverGame";
   soundButtonDown = "AudioButtonSellItem";
};

//-----------------------------------------------------------------------------
// Further profile initializations
if(isObject(WestwardSliderProfile)) {
   WestwardSliderProfile.soundButtonDown = "AudioButtonSlider";
}